//	    File: IOHIDElement_.h
//*****************************************************
#ifndef __IOHIDElement___
#define __IOHIDElement___

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"
//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidElement( inIOHIDElementRef )
	//
	// Purpose:	validate this element
	//
	// Inputs:	inIOHIDElementRef	- the element
	//
	// Returns:	Boolean			- TRUE if this is a valid element ref
	//
	extern Boolean HIDIsValidElement(IOHIDElementRef inIOHIDElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_GetValue( inElementRef, inIOHIDValueScaleType )
	//
	// Purpose:	returns the current value for an element( polling )
	//
	// Notes:	will return 0 on error conditions which should be accounted for by application
	//
	// Inputs:	inElementRef	- the element
	//			inIOHIDValueScaleType	- scale type ( calibrated or physical )
	//
	// Returns:	double		- current value for element
	//
	extern double IOHIDElement_GetValue(IOHIDElementRef inElementRef, IOHIDValueScaleType inIOHIDValueScaleType);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMin( inElementRef )
	//
	// Purpose:	get the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the minimum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the minimum bounds for a calibrated value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMax( inElementRef )
	//
	// Purpose:	get the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMin( inElementRef )
	//
	// Purpose:	get the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMin( inElementRef, inValue )
	//
	// Purpose:	set the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMax( inElementRef )
	//
	// Purpose:	get the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMin( inElementRef )
	//
	// Purpose:	get the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMax( inElementRef )
	//
	// Purpose:	get the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationGranularity( inElementRef )
	//
	// Purpose:	get the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	double_t - the maximum Calibration value for this element
	//
	
	extern double_t  IOHIDElement_GetCalibrationGranularity(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationGranularity( inElementRef, inValue )
	//
	// Purpose:	set the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the the level of detail for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationGranularity(IOHIDElementRef inElementRef, double_t inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_SetupCalibration( inElementRef )
	//
	// Purpose:	set default values for the element calibration parameters
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetupCalibration(IOHIDElementRef inIOHIDElementRef);
	
	extern Boolean IOHIDElement_GetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long *outValue);
	extern void IOHIDElement_SetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long inValue);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDElement___ //
//	Abstract: convieance functions for IOHIDElementGetProperty
//*****************************************************
#ifndef __IOHIDElement___
#define __IOHIDElement___

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"
//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidElement( inIOHIDElementRef )
	//
	// Purpose:	validate this element
	//
	// Inputs:	inIOHIDElementRef	- the element
	//
	// Returns:	Boolean			- TRUE if this is a valid element ref
	//
	extern Boolean HIDIsValidElement(IOHIDElementRef inIOHIDElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_GetValue( inElementRef, inIOHIDValueScaleType )
	//
	// Purpose:	returns the current value for an element( polling )
	//
	// Notes:	will return 0 on error conditions which should be accounted for by application
	//
	// Inputs:	inElementRef	- the element
	//			inIOHIDValueScaleType	- scale type ( calibrated or physical )
	//
	// Returns:	double		- current value for element
	//
	extern double IOHIDElement_GetValue(IOHIDElementRef inElementRef, IOHIDValueScaleType inIOHIDValueScaleType);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMin( inElementRef )
	//
	// Purpose:	get the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the minimum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the minimum bounds for a calibrated value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMax( inElementRef )
	//
	// Purpose:	get the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMin( inElementRef )
	//
	// Purpose:	get the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMin( inElementRef, inValue )
	//
	// Purpose:	set the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMax( inElementRef )
	//
	// Purpose:	get the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMin( inElementRef )
	//
	// Purpose:	get the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMax( inElementRef )
	//
	// Purpose:	get the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationGranularity( inElementRef )
	//
	// Purpose:	get the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	double_t - the maximum Calibration value for this element
	//
	
	extern double_t  IOHIDElement_GetCalibrationGranularity(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationGranularity( inElementRef, inValue )
	//
	// Purpose:	set the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the the level of detail for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationGranularity(IOHIDElementRef inElementRef, double_t inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_SetupCalibration( inElementRef )
	//
	// Purpose:	set default values for the element calibration parameters
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetupCalibration(IOHIDElementRef inIOHIDElementRef);
	
	extern Boolean IOHIDElement_GetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long *outValue);
	extern void IOHIDElement_SetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long inValue);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDElement___ //
//	 Version: 2.0
//*****************************************************
#ifndef __IOHIDElement___
#define __IOHIDElement___

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"
//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidElement( inIOHIDElementRef )
	//
	// Purpose:	validate this element
	//
	// Inputs:	inIOHIDElementRef	- the element
	//
	// Returns:	Boolean			- TRUE if this is a valid element ref
	//
	extern Boolean HIDIsValidElement(IOHIDElementRef inIOHIDElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_GetValue( inElementRef, inIOHIDValueScaleType )
	//
	// Purpose:	returns the current value for an element( polling )
	//
	// Notes:	will return 0 on error conditions which should be accounted for by application
	//
	// Inputs:	inElementRef	- the element
	//			inIOHIDValueScaleType	- scale type ( calibrated or physical )
	//
	// Returns:	double		- current value for element
	//
	extern double IOHIDElement_GetValue(IOHIDElementRef inElementRef, IOHIDValueScaleType inIOHIDValueScaleType);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMin( inElementRef )
	//
	// Purpose:	get the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the minimum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the minimum bounds for a calibrated value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMax( inElementRef )
	//
	// Purpose:	get the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMin( inElementRef )
	//
	// Purpose:	get the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMin( inElementRef, inValue )
	//
	// Purpose:	set the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMax( inElementRef )
	//
	// Purpose:	get the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMin( inElementRef )
	//
	// Purpose:	get the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMax( inElementRef )
	//
	// Purpose:	get the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationGranularity( inElementRef )
	//
	// Purpose:	get the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	double_t - the maximum Calibration value for this element
	//
	
	extern double_t  IOHIDElement_GetCalibrationGranularity(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationGranularity( inElementRef, inValue )
	//
	// Purpose:	set the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the the level of detail for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationGranularity(IOHIDElementRef inElementRef, double_t inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_SetupCalibration( inElementRef )
	//
	// Purpose:	set default values for the element calibration parameters
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetupCalibration(IOHIDElementRef inIOHIDElementRef);
	
	extern Boolean IOHIDElement_GetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long *outValue);
	extern void IOHIDElement_SetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long inValue);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDElement___ //
//	
//*****************************************************
#ifndef __IOHIDElement___
#define __IOHIDElement___

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"
//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidElement( inIOHIDElementRef )
	//
	// Purpose:	validate this element
	//
	// Inputs:	inIOHIDElementRef	- the element
	//
	// Returns:	Boolean			- TRUE if this is a valid element ref
	//
	extern Boolean HIDIsValidElement(IOHIDElementRef inIOHIDElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_GetValue( inElementRef, inIOHIDValueScaleType )
	//
	// Purpose:	returns the current value for an element( polling )
	//
	// Notes:	will return 0 on error conditions which should be accounted for by application
	//
	// Inputs:	inElementRef	- the element
	//			inIOHIDValueScaleType	- scale type ( calibrated or physical )
	//
	// Returns:	double		- current value for element
	//
	extern double IOHIDElement_GetValue(IOHIDElementRef inElementRef, IOHIDValueScaleType inIOHIDValueScaleType);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMin( inElementRef )
	//
	// Purpose:	get the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the minimum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the minimum bounds for a calibrated value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMax( inElementRef )
	//
	// Purpose:	get the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMin( inElementRef )
	//
	// Purpose:	get the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMin( inElementRef, inValue )
	//
	// Purpose:	set the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMax( inElementRef )
	//
	// Purpose:	get the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMin( inElementRef )
	//
	// Purpose:	get the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMax( inElementRef )
	//
	// Purpose:	get the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationGranularity( inElementRef )
	//
	// Purpose:	get the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	double_t - the maximum Calibration value for this element
	//
	
	extern double_t  IOHIDElement_GetCalibrationGranularity(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationGranularity( inElementRef, inValue )
	//
	// Purpose:	set the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the the level of detail for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationGranularity(IOHIDElementRef inElementRef, double_t inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_SetupCalibration( inElementRef )
	//
	// Purpose:	set default values for the element calibration parameters
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetupCalibration(IOHIDElementRef inIOHIDElementRef);
	
	extern Boolean IOHIDElement_GetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long *outValue);
	extern void IOHIDElement_SetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long inValue);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDElement___ //
//	Disclaimer: IMPORTANT:  This Apple software is supplied to you by Apple
//*****************************************************
#ifndef __IOHIDElement___
#define __IOHIDElement___

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"
//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidElement( inIOHIDElementRef )
	//
	// Purpose:	validate this element
	//
	// Inputs:	inIOHIDElementRef	- the element
	//
	// Returns:	Boolean			- TRUE if this is a valid element ref
	//
	extern Boolean HIDIsValidElement(IOHIDElementRef inIOHIDElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_GetValue( inElementRef, inIOHIDValueScaleType )
	//
	// Purpose:	returns the current value for an element( polling )
	//
	// Notes:	will return 0 on error conditions which should be accounted for by application
	//
	// Inputs:	inElementRef	- the element
	//			inIOHIDValueScaleType	- scale type ( calibrated or physical )
	//
	// Returns:	double		- current value for element
	//
	extern double IOHIDElement_GetValue(IOHIDElementRef inElementRef, IOHIDValueScaleType inIOHIDValueScaleType);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMin( inElementRef )
	//
	// Purpose:	get the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the minimum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the minimum bounds for a calibrated value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMax( inElementRef )
	//
	// Purpose:	get the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMin( inElementRef )
	//
	// Purpose:	get the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMin( inElementRef, inValue )
	//
	// Purpose:	set the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMax( inElementRef )
	//
	// Purpose:	get the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMin( inElementRef )
	//
	// Purpose:	get the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMax( inElementRef )
	//
	// Purpose:	get the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationGranularity( inElementRef )
	//
	// Purpose:	get the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	double_t - the maximum Calibration value for this element
	//
	
	extern double_t  IOHIDElement_GetCalibrationGranularity(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationGranularity( inElementRef, inValue )
	//
	// Purpose:	set the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the the level of detail for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationGranularity(IOHIDElementRef inElementRef, double_t inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_SetupCalibration( inElementRef )
	//
	// Purpose:	set default values for the element calibration parameters
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetupCalibration(IOHIDElementRef inIOHIDElementRef);
	
	extern Boolean IOHIDElement_GetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long *outValue);
	extern void IOHIDElement_SetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long inValue);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDElement___ //
//	Inc. ("Apple") in consideration of your agreement to the following
//*****************************************************
#ifndef __IOHIDElement___
#define __IOHIDElement___

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"
//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidElement( inIOHIDElementRef )
	//
	// Purpose:	validate this element
	//
	// Inputs:	inIOHIDElementRef	- the element
	//
	// Returns:	Boolean			- TRUE if this is a valid element ref
	//
	extern Boolean HIDIsValidElement(IOHIDElementRef inIOHIDElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_GetValue( inElementRef, inIOHIDValueScaleType )
	//
	// Purpose:	returns the current value for an element( polling )
	//
	// Notes:	will return 0 on error conditions which should be accounted for by application
	//
	// Inputs:	inElementRef	- the element
	//			inIOHIDValueScaleType	- scale type ( calibrated or physical )
	//
	// Returns:	double		- current value for element
	//
	extern double IOHIDElement_GetValue(IOHIDElementRef inElementRef, IOHIDValueScaleType inIOHIDValueScaleType);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMin( inElementRef )
	//
	// Purpose:	get the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the minimum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the minimum bounds for a calibrated value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMax( inElementRef )
	//
	// Purpose:	get the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMin( inElementRef )
	//
	// Purpose:	get the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMin( inElementRef, inValue )
	//
	// Purpose:	set the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMax( inElementRef )
	//
	// Purpose:	get the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMin( inElementRef )
	//
	// Purpose:	get the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMax( inElementRef )
	//
	// Purpose:	get the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationGranularity( inElementRef )
	//
	// Purpose:	get the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	double_t - the maximum Calibration value for this element
	//
	
	extern double_t  IOHIDElement_GetCalibrationGranularity(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationGranularity( inElementRef, inValue )
	//
	// Purpose:	set the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the the level of detail for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationGranularity(IOHIDElementRef inElementRef, double_t inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_SetupCalibration( inElementRef )
	//
	// Purpose:	set default values for the element calibration parameters
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetupCalibration(IOHIDElementRef inIOHIDElementRef);
	
	extern Boolean IOHIDElement_GetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long *outValue);
	extern void IOHIDElement_SetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long inValue);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDElement___ //
//	terms, and your use, installation, modification or redistribution of
//*****************************************************
#ifndef __IOHIDElement___
#define __IOHIDElement___

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"
//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidElement( inIOHIDElementRef )
	//
	// Purpose:	validate this element
	//
	// Inputs:	inIOHIDElementRef	- the element
	//
	// Returns:	Boolean			- TRUE if this is a valid element ref
	//
	extern Boolean HIDIsValidElement(IOHIDElementRef inIOHIDElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_GetValue( inElementRef, inIOHIDValueScaleType )
	//
	// Purpose:	returns the current value for an element( polling )
	//
	// Notes:	will return 0 on error conditions which should be accounted for by application
	//
	// Inputs:	inElementRef	- the element
	//			inIOHIDValueScaleType	- scale type ( calibrated or physical )
	//
	// Returns:	double		- current value for element
	//
	extern double IOHIDElement_GetValue(IOHIDElementRef inElementRef, IOHIDValueScaleType inIOHIDValueScaleType);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMin( inElementRef )
	//
	// Purpose:	get the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the minimum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the minimum bounds for a calibrated value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMax( inElementRef )
	//
	// Purpose:	get the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMin( inElementRef )
	//
	// Purpose:	get the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMin( inElementRef, inValue )
	//
	// Purpose:	set the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMax( inElementRef )
	//
	// Purpose:	get the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMin( inElementRef )
	//
	// Purpose:	get the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMax( inElementRef )
	//
	// Purpose:	get the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationGranularity( inElementRef )
	//
	// Purpose:	get the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	double_t - the maximum Calibration value for this element
	//
	
	extern double_t  IOHIDElement_GetCalibrationGranularity(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationGranularity( inElementRef, inValue )
	//
	// Purpose:	set the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the the level of detail for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationGranularity(IOHIDElementRef inElementRef, double_t inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_SetupCalibration( inElementRef )
	//
	// Purpose:	set default values for the element calibration parameters
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetupCalibration(IOHIDElementRef inIOHIDElementRef);
	
	extern Boolean IOHIDElement_GetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long *outValue);
	extern void IOHIDElement_SetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long inValue);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDElement___ //
//	this Apple software constitutes acceptance of these terms.  If you do
//*****************************************************
#ifndef __IOHIDElement___
#define __IOHIDElement___

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"
//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidElement( inIOHIDElementRef )
	//
	// Purpose:	validate this element
	//
	// Inputs:	inIOHIDElementRef	- the element
	//
	// Returns:	Boolean			- TRUE if this is a valid element ref
	//
	extern Boolean HIDIsValidElement(IOHIDElementRef inIOHIDElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_GetValue( inElementRef, inIOHIDValueScaleType )
	//
	// Purpose:	returns the current value for an element( polling )
	//
	// Notes:	will return 0 on error conditions which should be accounted for by application
	//
	// Inputs:	inElementRef	- the element
	//			inIOHIDValueScaleType	- scale type ( calibrated or physical )
	//
	// Returns:	double		- current value for element
	//
	extern double IOHIDElement_GetValue(IOHIDElementRef inElementRef, IOHIDValueScaleType inIOHIDValueScaleType);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMin( inElementRef )
	//
	// Purpose:	get the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the minimum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the minimum bounds for a calibrated value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMax( inElementRef )
	//
	// Purpose:	get the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMin( inElementRef )
	//
	// Purpose:	get the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMin( inElementRef, inValue )
	//
	// Purpose:	set the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMax( inElementRef )
	//
	// Purpose:	get the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMin( inElementRef )
	//
	// Purpose:	get the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMax( inElementRef )
	//
	// Purpose:	get the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationGranularity( inElementRef )
	//
	// Purpose:	get the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	double_t - the maximum Calibration value for this element
	//
	
	extern double_t  IOHIDElement_GetCalibrationGranularity(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationGranularity( inElementRef, inValue )
	//
	// Purpose:	set the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the the level of detail for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationGranularity(IOHIDElementRef inElementRef, double_t inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_SetupCalibration( inElementRef )
	//
	// Purpose:	set default values for the element calibration parameters
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetupCalibration(IOHIDElementRef inIOHIDElementRef);
	
	extern Boolean IOHIDElement_GetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long *outValue);
	extern void IOHIDElement_SetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long inValue);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDElement___ //
//	not agree with these terms, please do not use, install, modify or
//*****************************************************
#ifndef __IOHIDElement___
#define __IOHIDElement___

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"
//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidElement( inIOHIDElementRef )
	//
	// Purpose:	validate this element
	//
	// Inputs:	inIOHIDElementRef	- the element
	//
	// Returns:	Boolean			- TRUE if this is a valid element ref
	//
	extern Boolean HIDIsValidElement(IOHIDElementRef inIOHIDElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_GetValue( inElementRef, inIOHIDValueScaleType )
	//
	// Purpose:	returns the current value for an element( polling )
	//
	// Notes:	will return 0 on error conditions which should be accounted for by application
	//
	// Inputs:	inElementRef	- the element
	//			inIOHIDValueScaleType	- scale type ( calibrated or physical )
	//
	// Returns:	double		- current value for element
	//
	extern double IOHIDElement_GetValue(IOHIDElementRef inElementRef, IOHIDValueScaleType inIOHIDValueScaleType);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMin( inElementRef )
	//
	// Purpose:	get the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the minimum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the minimum bounds for a calibrated value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMax( inElementRef )
	//
	// Purpose:	get the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMin( inElementRef )
	//
	// Purpose:	get the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMin( inElementRef, inValue )
	//
	// Purpose:	set the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMax( inElementRef )
	//
	// Purpose:	get the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMin( inElementRef )
	//
	// Purpose:	get the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMax( inElementRef )
	//
	// Purpose:	get the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationGranularity( inElementRef )
	//
	// Purpose:	get the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	double_t - the maximum Calibration value for this element
	//
	
	extern double_t  IOHIDElement_GetCalibrationGranularity(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationGranularity( inElementRef, inValue )
	//
	// Purpose:	set the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the the level of detail for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationGranularity(IOHIDElementRef inElementRef, double_t inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_SetupCalibration( inElementRef )
	//
	// Purpose:	set default values for the element calibration parameters
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetupCalibration(IOHIDElementRef inIOHIDElementRef);
	
	extern Boolean IOHIDElement_GetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long *outValue);
	extern void IOHIDElement_SetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long inValue);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDElement___ //
//	redistribute this Apple software.
//*****************************************************
#ifndef __IOHIDElement___
#define __IOHIDElement___

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"
//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidElement( inIOHIDElementRef )
	//
	// Purpose:	validate this element
	//
	// Inputs:	inIOHIDElementRef	- the element
	//
	// Returns:	Boolean			- TRUE if this is a valid element ref
	//
	extern Boolean HIDIsValidElement(IOHIDElementRef inIOHIDElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_GetValue( inElementRef, inIOHIDValueScaleType )
	//
	// Purpose:	returns the current value for an element( polling )
	//
	// Notes:	will return 0 on error conditions which should be accounted for by application
	//
	// Inputs:	inElementRef	- the element
	//			inIOHIDValueScaleType	- scale type ( calibrated or physical )
	//
	// Returns:	double		- current value for element
	//
	extern double IOHIDElement_GetValue(IOHIDElementRef inElementRef, IOHIDValueScaleType inIOHIDValueScaleType);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMin( inElementRef )
	//
	// Purpose:	get the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the minimum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the minimum bounds for a calibrated value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMax( inElementRef )
	//
	// Purpose:	get the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMin( inElementRef )
	//
	// Purpose:	get the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMin( inElementRef, inValue )
	//
	// Purpose:	set the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMax( inElementRef )
	//
	// Purpose:	get the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMin( inElementRef )
	//
	// Purpose:	get the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMax( inElementRef )
	//
	// Purpose:	get the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationGranularity( inElementRef )
	//
	// Purpose:	get the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	double_t - the maximum Calibration value for this element
	//
	
	extern double_t  IOHIDElement_GetCalibrationGranularity(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationGranularity( inElementRef, inValue )
	//
	// Purpose:	set the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the the level of detail for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationGranularity(IOHIDElementRef inElementRef, double_t inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_SetupCalibration( inElementRef )
	//
	// Purpose:	set default values for the element calibration parameters
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetupCalibration(IOHIDElementRef inIOHIDElementRef);
	
	extern Boolean IOHIDElement_GetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long *outValue);
	extern void IOHIDElement_SetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long inValue);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDElement___ //
//	
//*****************************************************
#ifndef __IOHIDElement___
#define __IOHIDElement___

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"
//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidElement( inIOHIDElementRef )
	//
	// Purpose:	validate this element
	//
	// Inputs:	inIOHIDElementRef	- the element
	//
	// Returns:	Boolean			- TRUE if this is a valid element ref
	//
	extern Boolean HIDIsValidElement(IOHIDElementRef inIOHIDElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_GetValue( inElementRef, inIOHIDValueScaleType )
	//
	// Purpose:	returns the current value for an element( polling )
	//
	// Notes:	will return 0 on error conditions which should be accounted for by application
	//
	// Inputs:	inElementRef	- the element
	//			inIOHIDValueScaleType	- scale type ( calibrated or physical )
	//
	// Returns:	double		- current value for element
	//
	extern double IOHIDElement_GetValue(IOHIDElementRef inElementRef, IOHIDValueScaleType inIOHIDValueScaleType);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMin( inElementRef )
	//
	// Purpose:	get the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the minimum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the minimum bounds for a calibrated value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMax( inElementRef )
	//
	// Purpose:	get the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMin( inElementRef )
	//
	// Purpose:	get the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMin( inElementRef, inValue )
	//
	// Purpose:	set the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMax( inElementRef )
	//
	// Purpose:	get the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMin( inElementRef )
	//
	// Purpose:	get the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMax( inElementRef )
	//
	// Purpose:	get the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationGranularity( inElementRef )
	//
	// Purpose:	get the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	double_t - the maximum Calibration value for this element
	//
	
	extern double_t  IOHIDElement_GetCalibrationGranularity(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationGranularity( inElementRef, inValue )
	//
	// Purpose:	set the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the the level of detail for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationGranularity(IOHIDElementRef inElementRef, double_t inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_SetupCalibration( inElementRef )
	//
	// Purpose:	set default values for the element calibration parameters
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetupCalibration(IOHIDElementRef inIOHIDElementRef);
	
	extern Boolean IOHIDElement_GetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long *outValue);
	extern void IOHIDElement_SetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long inValue);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDElement___ //
//	In consideration of your agreement to abide by the following terms, and
//*****************************************************
#ifndef __IOHIDElement___
#define __IOHIDElement___

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"
//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidElement( inIOHIDElementRef )
	//
	// Purpose:	validate this element
	//
	// Inputs:	inIOHIDElementRef	- the element
	//
	// Returns:	Boolean			- TRUE if this is a valid element ref
	//
	extern Boolean HIDIsValidElement(IOHIDElementRef inIOHIDElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_GetValue( inElementRef, inIOHIDValueScaleType )
	//
	// Purpose:	returns the current value for an element( polling )
	//
	// Notes:	will return 0 on error conditions which should be accounted for by application
	//
	// Inputs:	inElementRef	- the element
	//			inIOHIDValueScaleType	- scale type ( calibrated or physical )
	//
	// Returns:	double		- current value for element
	//
	extern double IOHIDElement_GetValue(IOHIDElementRef inElementRef, IOHIDValueScaleType inIOHIDValueScaleType);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMin( inElementRef )
	//
	// Purpose:	get the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the minimum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the minimum bounds for a calibrated value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMax( inElementRef )
	//
	// Purpose:	get the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMin( inElementRef )
	//
	// Purpose:	get the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMin( inElementRef, inValue )
	//
	// Purpose:	set the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMax( inElementRef )
	//
	// Purpose:	get the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMin( inElementRef )
	//
	// Purpose:	get the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMax( inElementRef )
	//
	// Purpose:	get the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationGranularity( inElementRef )
	//
	// Purpose:	get the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	double_t - the maximum Calibration value for this element
	//
	
	extern double_t  IOHIDElement_GetCalibrationGranularity(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationGranularity( inElementRef, inValue )
	//
	// Purpose:	set the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the the level of detail for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationGranularity(IOHIDElementRef inElementRef, double_t inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_SetupCalibration( inElementRef )
	//
	// Purpose:	set default values for the element calibration parameters
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetupCalibration(IOHIDElementRef inIOHIDElementRef);
	
	extern Boolean IOHIDElement_GetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long *outValue);
	extern void IOHIDElement_SetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long inValue);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDElement___ //
//	subject to these terms, Apple grants you a personal, non-exclusive
//*****************************************************
#ifndef __IOHIDElement___
#define __IOHIDElement___

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"
//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidElement( inIOHIDElementRef )
	//
	// Purpose:	validate this element
	//
	// Inputs:	inIOHIDElementRef	- the element
	//
	// Returns:	Boolean			- TRUE if this is a valid element ref
	//
	extern Boolean HIDIsValidElement(IOHIDElementRef inIOHIDElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_GetValue( inElementRef, inIOHIDValueScaleType )
	//
	// Purpose:	returns the current value for an element( polling )
	//
	// Notes:	will return 0 on error conditions which should be accounted for by application
	//
	// Inputs:	inElementRef	- the element
	//			inIOHIDValueScaleType	- scale type ( calibrated or physical )
	//
	// Returns:	double		- current value for element
	//
	extern double IOHIDElement_GetValue(IOHIDElementRef inElementRef, IOHIDValueScaleType inIOHIDValueScaleType);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMin( inElementRef )
	//
	// Purpose:	get the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the minimum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the minimum bounds for a calibrated value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMax( inElementRef )
	//
	// Purpose:	get the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMin( inElementRef )
	//
	// Purpose:	get the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMin( inElementRef, inValue )
	//
	// Purpose:	set the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMax( inElementRef )
	//
	// Purpose:	get the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMin( inElementRef )
	//
	// Purpose:	get the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMax( inElementRef )
	//
	// Purpose:	get the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationGranularity( inElementRef )
	//
	// Purpose:	get the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	double_t - the maximum Calibration value for this element
	//
	
	extern double_t  IOHIDElement_GetCalibrationGranularity(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationGranularity( inElementRef, inValue )
	//
	// Purpose:	set the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the the level of detail for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationGranularity(IOHIDElementRef inElementRef, double_t inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_SetupCalibration( inElementRef )
	//
	// Purpose:	set default values for the element calibration parameters
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetupCalibration(IOHIDElementRef inIOHIDElementRef);
	
	extern Boolean IOHIDElement_GetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long *outValue);
	extern void IOHIDElement_SetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long inValue);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDElement___ //
//	license, under Apple's copyrights in this original Apple software (the
//*****************************************************
#ifndef __IOHIDElement___
#define __IOHIDElement___

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"
//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidElement( inIOHIDElementRef )
	//
	// Purpose:	validate this element
	//
	// Inputs:	inIOHIDElementRef	- the element
	//
	// Returns:	Boolean			- TRUE if this is a valid element ref
	//
	extern Boolean HIDIsValidElement(IOHIDElementRef inIOHIDElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_GetValue( inElementRef, inIOHIDValueScaleType )
	//
	// Purpose:	returns the current value for an element( polling )
	//
	// Notes:	will return 0 on error conditions which should be accounted for by application
	//
	// Inputs:	inElementRef	- the element
	//			inIOHIDValueScaleType	- scale type ( calibrated or physical )
	//
	// Returns:	double		- current value for element
	//
	extern double IOHIDElement_GetValue(IOHIDElementRef inElementRef, IOHIDValueScaleType inIOHIDValueScaleType);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMin( inElementRef )
	//
	// Purpose:	get the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the minimum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the minimum bounds for a calibrated value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMax( inElementRef )
	//
	// Purpose:	get the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMin( inElementRef )
	//
	// Purpose:	get the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMin( inElementRef, inValue )
	//
	// Purpose:	set the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMax( inElementRef )
	//
	// Purpose:	get the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMin( inElementRef )
	//
	// Purpose:	get the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMax( inElementRef )
	//
	// Purpose:	get the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationGranularity( inElementRef )
	//
	// Purpose:	get the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	double_t - the maximum Calibration value for this element
	//
	
	extern double_t  IOHIDElement_GetCalibrationGranularity(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationGranularity( inElementRef, inValue )
	//
	// Purpose:	set the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the the level of detail for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationGranularity(IOHIDElementRef inElementRef, double_t inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_SetupCalibration( inElementRef )
	//
	// Purpose:	set default values for the element calibration parameters
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetupCalibration(IOHIDElementRef inIOHIDElementRef);
	
	extern Boolean IOHIDElement_GetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long *outValue);
	extern void IOHIDElement_SetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long inValue);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDElement___ //
//	"Apple Software"), to use, reproduce, modify and redistribute the Apple
//*****************************************************
#ifndef __IOHIDElement___
#define __IOHIDElement___

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"
//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidElement( inIOHIDElementRef )
	//
	// Purpose:	validate this element
	//
	// Inputs:	inIOHIDElementRef	- the element
	//
	// Returns:	Boolean			- TRUE if this is a valid element ref
	//
	extern Boolean HIDIsValidElement(IOHIDElementRef inIOHIDElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_GetValue( inElementRef, inIOHIDValueScaleType )
	//
	// Purpose:	returns the current value for an element( polling )
	//
	// Notes:	will return 0 on error conditions which should be accounted for by application
	//
	// Inputs:	inElementRef	- the element
	//			inIOHIDValueScaleType	- scale type ( calibrated or physical )
	//
	// Returns:	double		- current value for element
	//
	extern double IOHIDElement_GetValue(IOHIDElementRef inElementRef, IOHIDValueScaleType inIOHIDValueScaleType);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMin( inElementRef )
	//
	// Purpose:	get the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the minimum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the minimum bounds for a calibrated value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMax( inElementRef )
	//
	// Purpose:	get the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMin( inElementRef )
	//
	// Purpose:	get the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMin( inElementRef, inValue )
	//
	// Purpose:	set the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMax( inElementRef )
	//
	// Purpose:	get the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMin( inElementRef )
	//
	// Purpose:	get the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMax( inElementRef )
	//
	// Purpose:	get the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationGranularity( inElementRef )
	//
	// Purpose:	get the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	double_t - the maximum Calibration value for this element
	//
	
	extern double_t  IOHIDElement_GetCalibrationGranularity(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationGranularity( inElementRef, inValue )
	//
	// Purpose:	set the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the the level of detail for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationGranularity(IOHIDElementRef inElementRef, double_t inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_SetupCalibration( inElementRef )
	//
	// Purpose:	set default values for the element calibration parameters
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetupCalibration(IOHIDElementRef inIOHIDElementRef);
	
	extern Boolean IOHIDElement_GetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long *outValue);
	extern void IOHIDElement_SetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long inValue);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDElement___ //
//	Software, with or without modifications, in source and/or binary forms;
//*****************************************************
#ifndef __IOHIDElement___
#define __IOHIDElement___

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"
//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidElement( inIOHIDElementRef )
	//
	// Purpose:	validate this element
	//
	// Inputs:	inIOHIDElementRef	- the element
	//
	// Returns:	Boolean			- TRUE if this is a valid element ref
	//
	extern Boolean HIDIsValidElement(IOHIDElementRef inIOHIDElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_GetValue( inElementRef, inIOHIDValueScaleType )
	//
	// Purpose:	returns the current value for an element( polling )
	//
	// Notes:	will return 0 on error conditions which should be accounted for by application
	//
	// Inputs:	inElementRef	- the element
	//			inIOHIDValueScaleType	- scale type ( calibrated or physical )
	//
	// Returns:	double		- current value for element
	//
	extern double IOHIDElement_GetValue(IOHIDElementRef inElementRef, IOHIDValueScaleType inIOHIDValueScaleType);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMin( inElementRef )
	//
	// Purpose:	get the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the minimum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the minimum bounds for a calibrated value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMax( inElementRef )
	//
	// Purpose:	get the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMin( inElementRef )
	//
	// Purpose:	get the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMin( inElementRef, inValue )
	//
	// Purpose:	set the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMax( inElementRef )
	//
	// Purpose:	get the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMin( inElementRef )
	//
	// Purpose:	get the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMax( inElementRef )
	//
	// Purpose:	get the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationGranularity( inElementRef )
	//
	// Purpose:	get the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	double_t - the maximum Calibration value for this element
	//
	
	extern double_t  IOHIDElement_GetCalibrationGranularity(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationGranularity( inElementRef, inValue )
	//
	// Purpose:	set the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the the level of detail for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationGranularity(IOHIDElementRef inElementRef, double_t inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_SetupCalibration( inElementRef )
	//
	// Purpose:	set default values for the element calibration parameters
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetupCalibration(IOHIDElementRef inIOHIDElementRef);
	
	extern Boolean IOHIDElement_GetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long *outValue);
	extern void IOHIDElement_SetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long inValue);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDElement___ //
//	provided that if you redistribute the Apple Software in its entirety and
//*****************************************************
#ifndef __IOHIDElement___
#define __IOHIDElement___

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"
//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidElement( inIOHIDElementRef )
	//
	// Purpose:	validate this element
	//
	// Inputs:	inIOHIDElementRef	- the element
	//
	// Returns:	Boolean			- TRUE if this is a valid element ref
	//
	extern Boolean HIDIsValidElement(IOHIDElementRef inIOHIDElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_GetValue( inElementRef, inIOHIDValueScaleType )
	//
	// Purpose:	returns the current value for an element( polling )
	//
	// Notes:	will return 0 on error conditions which should be accounted for by application
	//
	// Inputs:	inElementRef	- the element
	//			inIOHIDValueScaleType	- scale type ( calibrated or physical )
	//
	// Returns:	double		- current value for element
	//
	extern double IOHIDElement_GetValue(IOHIDElementRef inElementRef, IOHIDValueScaleType inIOHIDValueScaleType);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMin( inElementRef )
	//
	// Purpose:	get the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the minimum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the minimum bounds for a calibrated value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMax( inElementRef )
	//
	// Purpose:	get the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMin( inElementRef )
	//
	// Purpose:	get the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMin( inElementRef, inValue )
	//
	// Purpose:	set the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMax( inElementRef )
	//
	// Purpose:	get the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMin( inElementRef )
	//
	// Purpose:	get the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMax( inElementRef )
	//
	// Purpose:	get the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationGranularity( inElementRef )
	//
	// Purpose:	get the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	double_t - the maximum Calibration value for this element
	//
	
	extern double_t  IOHIDElement_GetCalibrationGranularity(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationGranularity( inElementRef, inValue )
	//
	// Purpose:	set the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the the level of detail for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationGranularity(IOHIDElementRef inElementRef, double_t inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_SetupCalibration( inElementRef )
	//
	// Purpose:	set default values for the element calibration parameters
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetupCalibration(IOHIDElementRef inIOHIDElementRef);
	
	extern Boolean IOHIDElement_GetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long *outValue);
	extern void IOHIDElement_SetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long inValue);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDElement___ //
//	without modifications, you must retain this notice and the following
//*****************************************************
#ifndef __IOHIDElement___
#define __IOHIDElement___

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"
//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidElement( inIOHIDElementRef )
	//
	// Purpose:	validate this element
	//
	// Inputs:	inIOHIDElementRef	- the element
	//
	// Returns:	Boolean			- TRUE if this is a valid element ref
	//
	extern Boolean HIDIsValidElement(IOHIDElementRef inIOHIDElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_GetValue( inElementRef, inIOHIDValueScaleType )
	//
	// Purpose:	returns the current value for an element( polling )
	//
	// Notes:	will return 0 on error conditions which should be accounted for by application
	//
	// Inputs:	inElementRef	- the element
	//			inIOHIDValueScaleType	- scale type ( calibrated or physical )
	//
	// Returns:	double		- current value for element
	//
	extern double IOHIDElement_GetValue(IOHIDElementRef inElementRef, IOHIDValueScaleType inIOHIDValueScaleType);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMin( inElementRef )
	//
	// Purpose:	get the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the minimum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the minimum bounds for a calibrated value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMax( inElementRef )
	//
	// Purpose:	get the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMin( inElementRef )
	//
	// Purpose:	get the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMin( inElementRef, inValue )
	//
	// Purpose:	set the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMax( inElementRef )
	//
	// Purpose:	get the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMin( inElementRef )
	//
	// Purpose:	get the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMax( inElementRef )
	//
	// Purpose:	get the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationGranularity( inElementRef )
	//
	// Purpose:	get the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	double_t - the maximum Calibration value for this element
	//
	
	extern double_t  IOHIDElement_GetCalibrationGranularity(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationGranularity( inElementRef, inValue )
	//
	// Purpose:	set the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the the level of detail for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationGranularity(IOHIDElementRef inElementRef, double_t inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_SetupCalibration( inElementRef )
	//
	// Purpose:	set default values for the element calibration parameters
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetupCalibration(IOHIDElementRef inIOHIDElementRef);
	
	extern Boolean IOHIDElement_GetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long *outValue);
	extern void IOHIDElement_SetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long inValue);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDElement___ //
//	text and disclaimers in all such redistributions of the Apple Software.
//*****************************************************
#ifndef __IOHIDElement___
#define __IOHIDElement___

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"
//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidElement( inIOHIDElementRef )
	//
	// Purpose:	validate this element
	//
	// Inputs:	inIOHIDElementRef	- the element
	//
	// Returns:	Boolean			- TRUE if this is a valid element ref
	//
	extern Boolean HIDIsValidElement(IOHIDElementRef inIOHIDElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_GetValue( inElementRef, inIOHIDValueScaleType )
	//
	// Purpose:	returns the current value for an element( polling )
	//
	// Notes:	will return 0 on error conditions which should be accounted for by application
	//
	// Inputs:	inElementRef	- the element
	//			inIOHIDValueScaleType	- scale type ( calibrated or physical )
	//
	// Returns:	double		- current value for element
	//
	extern double IOHIDElement_GetValue(IOHIDElementRef inElementRef, IOHIDValueScaleType inIOHIDValueScaleType);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMin( inElementRef )
	//
	// Purpose:	get the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the minimum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the minimum bounds for a calibrated value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMax( inElementRef )
	//
	// Purpose:	get the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMin( inElementRef )
	//
	// Purpose:	get the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMin( inElementRef, inValue )
	//
	// Purpose:	set the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMax( inElementRef )
	//
	// Purpose:	get the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMin( inElementRef )
	//
	// Purpose:	get the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMax( inElementRef )
	//
	// Purpose:	get the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationGranularity( inElementRef )
	//
	// Purpose:	get the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	double_t - the maximum Calibration value for this element
	//
	
	extern double_t  IOHIDElement_GetCalibrationGranularity(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationGranularity( inElementRef, inValue )
	//
	// Purpose:	set the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the the level of detail for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationGranularity(IOHIDElementRef inElementRef, double_t inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_SetupCalibration( inElementRef )
	//
	// Purpose:	set default values for the element calibration parameters
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetupCalibration(IOHIDElementRef inIOHIDElementRef);
	
	extern Boolean IOHIDElement_GetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long *outValue);
	extern void IOHIDElement_SetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long inValue);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDElement___ //
//	Neither the name, trademarks, service marks or logos of Apple Inc. may
//*****************************************************
#ifndef __IOHIDElement___
#define __IOHIDElement___

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"
//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidElement( inIOHIDElementRef )
	//
	// Purpose:	validate this element
	//
	// Inputs:	inIOHIDElementRef	- the element
	//
	// Returns:	Boolean			- TRUE if this is a valid element ref
	//
	extern Boolean HIDIsValidElement(IOHIDElementRef inIOHIDElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_GetValue( inElementRef, inIOHIDValueScaleType )
	//
	// Purpose:	returns the current value for an element( polling )
	//
	// Notes:	will return 0 on error conditions which should be accounted for by application
	//
	// Inputs:	inElementRef	- the element
	//			inIOHIDValueScaleType	- scale type ( calibrated or physical )
	//
	// Returns:	double		- current value for element
	//
	extern double IOHIDElement_GetValue(IOHIDElementRef inElementRef, IOHIDValueScaleType inIOHIDValueScaleType);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMin( inElementRef )
	//
	// Purpose:	get the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the minimum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the minimum bounds for a calibrated value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMax( inElementRef )
	//
	// Purpose:	get the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMin( inElementRef )
	//
	// Purpose:	get the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMin( inElementRef, inValue )
	//
	// Purpose:	set the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMax( inElementRef )
	//
	// Purpose:	get the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMin( inElementRef )
	//
	// Purpose:	get the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMax( inElementRef )
	//
	// Purpose:	get the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationGranularity( inElementRef )
	//
	// Purpose:	get the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	double_t - the maximum Calibration value for this element
	//
	
	extern double_t  IOHIDElement_GetCalibrationGranularity(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationGranularity( inElementRef, inValue )
	//
	// Purpose:	set the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the the level of detail for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationGranularity(IOHIDElementRef inElementRef, double_t inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_SetupCalibration( inElementRef )
	//
	// Purpose:	set default values for the element calibration parameters
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetupCalibration(IOHIDElementRef inIOHIDElementRef);
	
	extern Boolean IOHIDElement_GetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long *outValue);
	extern void IOHIDElement_SetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long inValue);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDElement___ //
//	be used to endorse or promote products derived from the Apple Software
//*****************************************************
#ifndef __IOHIDElement___
#define __IOHIDElement___

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"
//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidElement( inIOHIDElementRef )
	//
	// Purpose:	validate this element
	//
	// Inputs:	inIOHIDElementRef	- the element
	//
	// Returns:	Boolean			- TRUE if this is a valid element ref
	//
	extern Boolean HIDIsValidElement(IOHIDElementRef inIOHIDElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_GetValue( inElementRef, inIOHIDValueScaleType )
	//
	// Purpose:	returns the current value for an element( polling )
	//
	// Notes:	will return 0 on error conditions which should be accounted for by application
	//
	// Inputs:	inElementRef	- the element
	//			inIOHIDValueScaleType	- scale type ( calibrated or physical )
	//
	// Returns:	double		- current value for element
	//
	extern double IOHIDElement_GetValue(IOHIDElementRef inElementRef, IOHIDValueScaleType inIOHIDValueScaleType);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMin( inElementRef )
	//
	// Purpose:	get the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the minimum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the minimum bounds for a calibrated value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMax( inElementRef )
	//
	// Purpose:	get the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMin( inElementRef )
	//
	// Purpose:	get the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMin( inElementRef, inValue )
	//
	// Purpose:	set the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMax( inElementRef )
	//
	// Purpose:	get the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMin( inElementRef )
	//
	// Purpose:	get the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMax( inElementRef )
	//
	// Purpose:	get the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationGranularity( inElementRef )
	//
	// Purpose:	get the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	double_t - the maximum Calibration value for this element
	//
	
	extern double_t  IOHIDElement_GetCalibrationGranularity(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationGranularity( inElementRef, inValue )
	//
	// Purpose:	set the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the the level of detail for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationGranularity(IOHIDElementRef inElementRef, double_t inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_SetupCalibration( inElementRef )
	//
	// Purpose:	set default values for the element calibration parameters
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetupCalibration(IOHIDElementRef inIOHIDElementRef);
	
	extern Boolean IOHIDElement_GetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long *outValue);
	extern void IOHIDElement_SetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long inValue);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDElement___ //
//	without specific prior written permission from Apple.  Except as
//*****************************************************
#ifndef __IOHIDElement___
#define __IOHIDElement___

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"
//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidElement( inIOHIDElementRef )
	//
	// Purpose:	validate this element
	//
	// Inputs:	inIOHIDElementRef	- the element
	//
	// Returns:	Boolean			- TRUE if this is a valid element ref
	//
	extern Boolean HIDIsValidElement(IOHIDElementRef inIOHIDElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_GetValue( inElementRef, inIOHIDValueScaleType )
	//
	// Purpose:	returns the current value for an element( polling )
	//
	// Notes:	will return 0 on error conditions which should be accounted for by application
	//
	// Inputs:	inElementRef	- the element
	//			inIOHIDValueScaleType	- scale type ( calibrated or physical )
	//
	// Returns:	double		- current value for element
	//
	extern double IOHIDElement_GetValue(IOHIDElementRef inElementRef, IOHIDValueScaleType inIOHIDValueScaleType);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMin( inElementRef )
	//
	// Purpose:	get the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the minimum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the minimum bounds for a calibrated value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMax( inElementRef )
	//
	// Purpose:	get the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMin( inElementRef )
	//
	// Purpose:	get the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMin( inElementRef, inValue )
	//
	// Purpose:	set the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMax( inElementRef )
	//
	// Purpose:	get the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMin( inElementRef )
	//
	// Purpose:	get the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMax( inElementRef )
	//
	// Purpose:	get the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationGranularity( inElementRef )
	//
	// Purpose:	get the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	double_t - the maximum Calibration value for this element
	//
	
	extern double_t  IOHIDElement_GetCalibrationGranularity(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationGranularity( inElementRef, inValue )
	//
	// Purpose:	set the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the the level of detail for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationGranularity(IOHIDElementRef inElementRef, double_t inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_SetupCalibration( inElementRef )
	//
	// Purpose:	set default values for the element calibration parameters
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetupCalibration(IOHIDElementRef inIOHIDElementRef);
	
	extern Boolean IOHIDElement_GetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long *outValue);
	extern void IOHIDElement_SetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long inValue);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDElement___ //
//	expressly stated in this notice, no other rights or licenses, express or
//*****************************************************
#ifndef __IOHIDElement___
#define __IOHIDElement___

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"
//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidElement( inIOHIDElementRef )
	//
	// Purpose:	validate this element
	//
	// Inputs:	inIOHIDElementRef	- the element
	//
	// Returns:	Boolean			- TRUE if this is a valid element ref
	//
	extern Boolean HIDIsValidElement(IOHIDElementRef inIOHIDElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_GetValue( inElementRef, inIOHIDValueScaleType )
	//
	// Purpose:	returns the current value for an element( polling )
	//
	// Notes:	will return 0 on error conditions which should be accounted for by application
	//
	// Inputs:	inElementRef	- the element
	//			inIOHIDValueScaleType	- scale type ( calibrated or physical )
	//
	// Returns:	double		- current value for element
	//
	extern double IOHIDElement_GetValue(IOHIDElementRef inElementRef, IOHIDValueScaleType inIOHIDValueScaleType);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMin( inElementRef )
	//
	// Purpose:	get the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the minimum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the minimum bounds for a calibrated value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMax( inElementRef )
	//
	// Purpose:	get the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMin( inElementRef )
	//
	// Purpose:	get the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMin( inElementRef, inValue )
	//
	// Purpose:	set the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMax( inElementRef )
	//
	// Purpose:	get the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMin( inElementRef )
	//
	// Purpose:	get the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMax( inElementRef )
	//
	// Purpose:	get the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationGranularity( inElementRef )
	//
	// Purpose:	get the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	double_t - the maximum Calibration value for this element
	//
	
	extern double_t  IOHIDElement_GetCalibrationGranularity(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationGranularity( inElementRef, inValue )
	//
	// Purpose:	set the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the the level of detail for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationGranularity(IOHIDElementRef inElementRef, double_t inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_SetupCalibration( inElementRef )
	//
	// Purpose:	set default values for the element calibration parameters
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetupCalibration(IOHIDElementRef inIOHIDElementRef);
	
	extern Boolean IOHIDElement_GetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long *outValue);
	extern void IOHIDElement_SetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long inValue);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDElement___ //
//	implied, are granted by Apple herein, including but not limited to any
//*****************************************************
#ifndef __IOHIDElement___
#define __IOHIDElement___

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"
//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidElement( inIOHIDElementRef )
	//
	// Purpose:	validate this element
	//
	// Inputs:	inIOHIDElementRef	- the element
	//
	// Returns:	Boolean			- TRUE if this is a valid element ref
	//
	extern Boolean HIDIsValidElement(IOHIDElementRef inIOHIDElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_GetValue( inElementRef, inIOHIDValueScaleType )
	//
	// Purpose:	returns the current value for an element( polling )
	//
	// Notes:	will return 0 on error conditions which should be accounted for by application
	//
	// Inputs:	inElementRef	- the element
	//			inIOHIDValueScaleType	- scale type ( calibrated or physical )
	//
	// Returns:	double		- current value for element
	//
	extern double IOHIDElement_GetValue(IOHIDElementRef inElementRef, IOHIDValueScaleType inIOHIDValueScaleType);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMin( inElementRef )
	//
	// Purpose:	get the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the minimum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the minimum bounds for a calibrated value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMax( inElementRef )
	//
	// Purpose:	get the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMin( inElementRef )
	//
	// Purpose:	get the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMin( inElementRef, inValue )
	//
	// Purpose:	set the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMax( inElementRef )
	//
	// Purpose:	get the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMin( inElementRef )
	//
	// Purpose:	get the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMax( inElementRef )
	//
	// Purpose:	get the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationGranularity( inElementRef )
	//
	// Purpose:	get the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	double_t - the maximum Calibration value for this element
	//
	
	extern double_t  IOHIDElement_GetCalibrationGranularity(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationGranularity( inElementRef, inValue )
	//
	// Purpose:	set the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the the level of detail for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationGranularity(IOHIDElementRef inElementRef, double_t inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_SetupCalibration( inElementRef )
	//
	// Purpose:	set default values for the element calibration parameters
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetupCalibration(IOHIDElementRef inIOHIDElementRef);
	
	extern Boolean IOHIDElement_GetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long *outValue);
	extern void IOHIDElement_SetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long inValue);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDElement___ //
//	patent rights that may be infringed by your derivative works or by other
//*****************************************************
#ifndef __IOHIDElement___
#define __IOHIDElement___

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"
//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidElement( inIOHIDElementRef )
	//
	// Purpose:	validate this element
	//
	// Inputs:	inIOHIDElementRef	- the element
	//
	// Returns:	Boolean			- TRUE if this is a valid element ref
	//
	extern Boolean HIDIsValidElement(IOHIDElementRef inIOHIDElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_GetValue( inElementRef, inIOHIDValueScaleType )
	//
	// Purpose:	returns the current value for an element( polling )
	//
	// Notes:	will return 0 on error conditions which should be accounted for by application
	//
	// Inputs:	inElementRef	- the element
	//			inIOHIDValueScaleType	- scale type ( calibrated or physical )
	//
	// Returns:	double		- current value for element
	//
	extern double IOHIDElement_GetValue(IOHIDElementRef inElementRef, IOHIDValueScaleType inIOHIDValueScaleType);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMin( inElementRef )
	//
	// Purpose:	get the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the minimum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the minimum bounds for a calibrated value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMax( inElementRef )
	//
	// Purpose:	get the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMin( inElementRef )
	//
	// Purpose:	get the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMin( inElementRef, inValue )
	//
	// Purpose:	set the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMax( inElementRef )
	//
	// Purpose:	get the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMin( inElementRef )
	//
	// Purpose:	get the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMax( inElementRef )
	//
	// Purpose:	get the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationGranularity( inElementRef )
	//
	// Purpose:	get the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	double_t - the maximum Calibration value for this element
	//
	
	extern double_t  IOHIDElement_GetCalibrationGranularity(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationGranularity( inElementRef, inValue )
	//
	// Purpose:	set the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the the level of detail for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationGranularity(IOHIDElementRef inElementRef, double_t inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_SetupCalibration( inElementRef )
	//
	// Purpose:	set default values for the element calibration parameters
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetupCalibration(IOHIDElementRef inIOHIDElementRef);
	
	extern Boolean IOHIDElement_GetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long *outValue);
	extern void IOHIDElement_SetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long inValue);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDElement___ //
//	works in which the Apple Software may be incorporated.
//*****************************************************
#ifndef __IOHIDElement___
#define __IOHIDElement___

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"
//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidElement( inIOHIDElementRef )
	//
	// Purpose:	validate this element
	//
	// Inputs:	inIOHIDElementRef	- the element
	//
	// Returns:	Boolean			- TRUE if this is a valid element ref
	//
	extern Boolean HIDIsValidElement(IOHIDElementRef inIOHIDElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_GetValue( inElementRef, inIOHIDValueScaleType )
	//
	// Purpose:	returns the current value for an element( polling )
	//
	// Notes:	will return 0 on error conditions which should be accounted for by application
	//
	// Inputs:	inElementRef	- the element
	//			inIOHIDValueScaleType	- scale type ( calibrated or physical )
	//
	// Returns:	double		- current value for element
	//
	extern double IOHIDElement_GetValue(IOHIDElementRef inElementRef, IOHIDValueScaleType inIOHIDValueScaleType);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMin( inElementRef )
	//
	// Purpose:	get the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the minimum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the minimum bounds for a calibrated value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMax( inElementRef )
	//
	// Purpose:	get the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMin( inElementRef )
	//
	// Purpose:	get the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMin( inElementRef, inValue )
	//
	// Purpose:	set the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMax( inElementRef )
	//
	// Purpose:	get the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMin( inElementRef )
	//
	// Purpose:	get the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMax( inElementRef )
	//
	// Purpose:	get the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationGranularity( inElementRef )
	//
	// Purpose:	get the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	double_t - the maximum Calibration value for this element
	//
	
	extern double_t  IOHIDElement_GetCalibrationGranularity(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationGranularity( inElementRef, inValue )
	//
	// Purpose:	set the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the the level of detail for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationGranularity(IOHIDElementRef inElementRef, double_t inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_SetupCalibration( inElementRef )
	//
	// Purpose:	set default values for the element calibration parameters
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetupCalibration(IOHIDElementRef inIOHIDElementRef);
	
	extern Boolean IOHIDElement_GetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long *outValue);
	extern void IOHIDElement_SetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long inValue);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDElement___ //
//	
//*****************************************************
#ifndef __IOHIDElement___
#define __IOHIDElement___

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"
//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidElement( inIOHIDElementRef )
	//
	// Purpose:	validate this element
	//
	// Inputs:	inIOHIDElementRef	- the element
	//
	// Returns:	Boolean			- TRUE if this is a valid element ref
	//
	extern Boolean HIDIsValidElement(IOHIDElementRef inIOHIDElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_GetValue( inElementRef, inIOHIDValueScaleType )
	//
	// Purpose:	returns the current value for an element( polling )
	//
	// Notes:	will return 0 on error conditions which should be accounted for by application
	//
	// Inputs:	inElementRef	- the element
	//			inIOHIDValueScaleType	- scale type ( calibrated or physical )
	//
	// Returns:	double		- current value for element
	//
	extern double IOHIDElement_GetValue(IOHIDElementRef inElementRef, IOHIDValueScaleType inIOHIDValueScaleType);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMin( inElementRef )
	//
	// Purpose:	get the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the minimum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the minimum bounds for a calibrated value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMax( inElementRef )
	//
	// Purpose:	get the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMin( inElementRef )
	//
	// Purpose:	get the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMin( inElementRef, inValue )
	//
	// Purpose:	set the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMax( inElementRef )
	//
	// Purpose:	get the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMin( inElementRef )
	//
	// Purpose:	get the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMax( inElementRef )
	//
	// Purpose:	get the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationGranularity( inElementRef )
	//
	// Purpose:	get the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	double_t - the maximum Calibration value for this element
	//
	
	extern double_t  IOHIDElement_GetCalibrationGranularity(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationGranularity( inElementRef, inValue )
	//
	// Purpose:	set the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the the level of detail for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationGranularity(IOHIDElementRef inElementRef, double_t inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_SetupCalibration( inElementRef )
	//
	// Purpose:	set default values for the element calibration parameters
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetupCalibration(IOHIDElementRef inIOHIDElementRef);
	
	extern Boolean IOHIDElement_GetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long *outValue);
	extern void IOHIDElement_SetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long inValue);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDElement___ //
//	The Apple Software is provided by Apple on an "AS IS" basis.  APPLE
//*****************************************************
#ifndef __IOHIDElement___
#define __IOHIDElement___

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"
//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidElement( inIOHIDElementRef )
	//
	// Purpose:	validate this element
	//
	// Inputs:	inIOHIDElementRef	- the element
	//
	// Returns:	Boolean			- TRUE if this is a valid element ref
	//
	extern Boolean HIDIsValidElement(IOHIDElementRef inIOHIDElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_GetValue( inElementRef, inIOHIDValueScaleType )
	//
	// Purpose:	returns the current value for an element( polling )
	//
	// Notes:	will return 0 on error conditions which should be accounted for by application
	//
	// Inputs:	inElementRef	- the element
	//			inIOHIDValueScaleType	- scale type ( calibrated or physical )
	//
	// Returns:	double		- current value for element
	//
	extern double IOHIDElement_GetValue(IOHIDElementRef inElementRef, IOHIDValueScaleType inIOHIDValueScaleType);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMin( inElementRef )
	//
	// Purpose:	get the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the minimum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the minimum bounds for a calibrated value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMax( inElementRef )
	//
	// Purpose:	get the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMin( inElementRef )
	//
	// Purpose:	get the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMin( inElementRef, inValue )
	//
	// Purpose:	set the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMax( inElementRef )
	//
	// Purpose:	get the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMin( inElementRef )
	//
	// Purpose:	get the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMax( inElementRef )
	//
	// Purpose:	get the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationGranularity( inElementRef )
	//
	// Purpose:	get the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	double_t - the maximum Calibration value for this element
	//
	
	extern double_t  IOHIDElement_GetCalibrationGranularity(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationGranularity( inElementRef, inValue )
	//
	// Purpose:	set the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the the level of detail for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationGranularity(IOHIDElementRef inElementRef, double_t inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_SetupCalibration( inElementRef )
	//
	// Purpose:	set default values for the element calibration parameters
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetupCalibration(IOHIDElementRef inIOHIDElementRef);
	
	extern Boolean IOHIDElement_GetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long *outValue);
	extern void IOHIDElement_SetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long inValue);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDElement___ //
//	MAKES NO WARRANTIES, EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION
//*****************************************************
#ifndef __IOHIDElement___
#define __IOHIDElement___

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"
//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidElement( inIOHIDElementRef )
	//
	// Purpose:	validate this element
	//
	// Inputs:	inIOHIDElementRef	- the element
	//
	// Returns:	Boolean			- TRUE if this is a valid element ref
	//
	extern Boolean HIDIsValidElement(IOHIDElementRef inIOHIDElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_GetValue( inElementRef, inIOHIDValueScaleType )
	//
	// Purpose:	returns the current value for an element( polling )
	//
	// Notes:	will return 0 on error conditions which should be accounted for by application
	//
	// Inputs:	inElementRef	- the element
	//			inIOHIDValueScaleType	- scale type ( calibrated or physical )
	//
	// Returns:	double		- current value for element
	//
	extern double IOHIDElement_GetValue(IOHIDElementRef inElementRef, IOHIDValueScaleType inIOHIDValueScaleType);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMin( inElementRef )
	//
	// Purpose:	get the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the minimum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the minimum bounds for a calibrated value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMax( inElementRef )
	//
	// Purpose:	get the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMin( inElementRef )
	//
	// Purpose:	get the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMin( inElementRef, inValue )
	//
	// Purpose:	set the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMax( inElementRef )
	//
	// Purpose:	get the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMin( inElementRef )
	//
	// Purpose:	get the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMax( inElementRef )
	//
	// Purpose:	get the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationGranularity( inElementRef )
	//
	// Purpose:	get the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	double_t - the maximum Calibration value for this element
	//
	
	extern double_t  IOHIDElement_GetCalibrationGranularity(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationGranularity( inElementRef, inValue )
	//
	// Purpose:	set the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the the level of detail for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationGranularity(IOHIDElementRef inElementRef, double_t inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_SetupCalibration( inElementRef )
	//
	// Purpose:	set default values for the element calibration parameters
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetupCalibration(IOHIDElementRef inIOHIDElementRef);
	
	extern Boolean IOHIDElement_GetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long *outValue);
	extern void IOHIDElement_SetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long inValue);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDElement___ //
//	THE IMPLIED WARRANTIES OF NON-INFRINGEMENT, MERCHANTABILITY AND FITNESS
//*****************************************************
#ifndef __IOHIDElement___
#define __IOHIDElement___

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"
//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidElement( inIOHIDElementRef )
	//
	// Purpose:	validate this element
	//
	// Inputs:	inIOHIDElementRef	- the element
	//
	// Returns:	Boolean			- TRUE if this is a valid element ref
	//
	extern Boolean HIDIsValidElement(IOHIDElementRef inIOHIDElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_GetValue( inElementRef, inIOHIDValueScaleType )
	//
	// Purpose:	returns the current value for an element( polling )
	//
	// Notes:	will return 0 on error conditions which should be accounted for by application
	//
	// Inputs:	inElementRef	- the element
	//			inIOHIDValueScaleType	- scale type ( calibrated or physical )
	//
	// Returns:	double		- current value for element
	//
	extern double IOHIDElement_GetValue(IOHIDElementRef inElementRef, IOHIDValueScaleType inIOHIDValueScaleType);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMin( inElementRef )
	//
	// Purpose:	get the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the minimum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the minimum bounds for a calibrated value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMax( inElementRef )
	//
	// Purpose:	get the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMin( inElementRef )
	//
	// Purpose:	get the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMin( inElementRef, inValue )
	//
	// Purpose:	set the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMax( inElementRef )
	//
	// Purpose:	get the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMin( inElementRef )
	//
	// Purpose:	get the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMax( inElementRef )
	//
	// Purpose:	get the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationGranularity( inElementRef )
	//
	// Purpose:	get the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	double_t - the maximum Calibration value for this element
	//
	
	extern double_t  IOHIDElement_GetCalibrationGranularity(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationGranularity( inElementRef, inValue )
	//
	// Purpose:	set the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the the level of detail for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationGranularity(IOHIDElementRef inElementRef, double_t inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_SetupCalibration( inElementRef )
	//
	// Purpose:	set default values for the element calibration parameters
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetupCalibration(IOHIDElementRef inIOHIDElementRef);
	
	extern Boolean IOHIDElement_GetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long *outValue);
	extern void IOHIDElement_SetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long inValue);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDElement___ //
//	FOR A PARTICULAR PURPOSE, REGARDING THE APPLE SOFTWARE OR ITS USE AND
//*****************************************************
#ifndef __IOHIDElement___
#define __IOHIDElement___

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"
//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidElement( inIOHIDElementRef )
	//
	// Purpose:	validate this element
	//
	// Inputs:	inIOHIDElementRef	- the element
	//
	// Returns:	Boolean			- TRUE if this is a valid element ref
	//
	extern Boolean HIDIsValidElement(IOHIDElementRef inIOHIDElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_GetValue( inElementRef, inIOHIDValueScaleType )
	//
	// Purpose:	returns the current value for an element( polling )
	//
	// Notes:	will return 0 on error conditions which should be accounted for by application
	//
	// Inputs:	inElementRef	- the element
	//			inIOHIDValueScaleType	- scale type ( calibrated or physical )
	//
	// Returns:	double		- current value for element
	//
	extern double IOHIDElement_GetValue(IOHIDElementRef inElementRef, IOHIDValueScaleType inIOHIDValueScaleType);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMin( inElementRef )
	//
	// Purpose:	get the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the minimum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the minimum bounds for a calibrated value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMax( inElementRef )
	//
	// Purpose:	get the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMin( inElementRef )
	//
	// Purpose:	get the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMin( inElementRef, inValue )
	//
	// Purpose:	set the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMax( inElementRef )
	//
	// Purpose:	get the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMin( inElementRef )
	//
	// Purpose:	get the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMax( inElementRef )
	//
	// Purpose:	get the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationGranularity( inElementRef )
	//
	// Purpose:	get the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	double_t - the maximum Calibration value for this element
	//
	
	extern double_t  IOHIDElement_GetCalibrationGranularity(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationGranularity( inElementRef, inValue )
	//
	// Purpose:	set the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the the level of detail for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationGranularity(IOHIDElementRef inElementRef, double_t inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_SetupCalibration( inElementRef )
	//
	// Purpose:	set default values for the element calibration parameters
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetupCalibration(IOHIDElementRef inIOHIDElementRef);
	
	extern Boolean IOHIDElement_GetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long *outValue);
	extern void IOHIDElement_SetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long inValue);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDElement___ //
//	OPERATION ALONE OR IN COMBINATION WITH YOUR PRODUCTS.
//*****************************************************
#ifndef __IOHIDElement___
#define __IOHIDElement___

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"
//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidElement( inIOHIDElementRef )
	//
	// Purpose:	validate this element
	//
	// Inputs:	inIOHIDElementRef	- the element
	//
	// Returns:	Boolean			- TRUE if this is a valid element ref
	//
	extern Boolean HIDIsValidElement(IOHIDElementRef inIOHIDElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_GetValue( inElementRef, inIOHIDValueScaleType )
	//
	// Purpose:	returns the current value for an element( polling )
	//
	// Notes:	will return 0 on error conditions which should be accounted for by application
	//
	// Inputs:	inElementRef	- the element
	//			inIOHIDValueScaleType	- scale type ( calibrated or physical )
	//
	// Returns:	double		- current value for element
	//
	extern double IOHIDElement_GetValue(IOHIDElementRef inElementRef, IOHIDValueScaleType inIOHIDValueScaleType);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMin( inElementRef )
	//
	// Purpose:	get the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the minimum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the minimum bounds for a calibrated value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMax( inElementRef )
	//
	// Purpose:	get the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMin( inElementRef )
	//
	// Purpose:	get the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMin( inElementRef, inValue )
	//
	// Purpose:	set the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMax( inElementRef )
	//
	// Purpose:	get the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMin( inElementRef )
	//
	// Purpose:	get the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMax( inElementRef )
	//
	// Purpose:	get the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationGranularity( inElementRef )
	//
	// Purpose:	get the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	double_t - the maximum Calibration value for this element
	//
	
	extern double_t  IOHIDElement_GetCalibrationGranularity(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationGranularity( inElementRef, inValue )
	//
	// Purpose:	set the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the the level of detail for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationGranularity(IOHIDElementRef inElementRef, double_t inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_SetupCalibration( inElementRef )
	//
	// Purpose:	set default values for the element calibration parameters
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetupCalibration(IOHIDElementRef inIOHIDElementRef);
	
	extern Boolean IOHIDElement_GetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long *outValue);
	extern void IOHIDElement_SetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long inValue);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDElement___ //
//	
//*****************************************************
#ifndef __IOHIDElement___
#define __IOHIDElement___

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"
//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidElement( inIOHIDElementRef )
	//
	// Purpose:	validate this element
	//
	// Inputs:	inIOHIDElementRef	- the element
	//
	// Returns:	Boolean			- TRUE if this is a valid element ref
	//
	extern Boolean HIDIsValidElement(IOHIDElementRef inIOHIDElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_GetValue( inElementRef, inIOHIDValueScaleType )
	//
	// Purpose:	returns the current value for an element( polling )
	//
	// Notes:	will return 0 on error conditions which should be accounted for by application
	//
	// Inputs:	inElementRef	- the element
	//			inIOHIDValueScaleType	- scale type ( calibrated or physical )
	//
	// Returns:	double		- current value for element
	//
	extern double IOHIDElement_GetValue(IOHIDElementRef inElementRef, IOHIDValueScaleType inIOHIDValueScaleType);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMin( inElementRef )
	//
	// Purpose:	get the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the minimum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the minimum bounds for a calibrated value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMax( inElementRef )
	//
	// Purpose:	get the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMin( inElementRef )
	//
	// Purpose:	get the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMin( inElementRef, inValue )
	//
	// Purpose:	set the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMax( inElementRef )
	//
	// Purpose:	get the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMin( inElementRef )
	//
	// Purpose:	get the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMax( inElementRef )
	//
	// Purpose:	get the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationGranularity( inElementRef )
	//
	// Purpose:	get the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	double_t - the maximum Calibration value for this element
	//
	
	extern double_t  IOHIDElement_GetCalibrationGranularity(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationGranularity( inElementRef, inValue )
	//
	// Purpose:	set the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the the level of detail for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationGranularity(IOHIDElementRef inElementRef, double_t inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_SetupCalibration( inElementRef )
	//
	// Purpose:	set default values for the element calibration parameters
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetupCalibration(IOHIDElementRef inIOHIDElementRef);
	
	extern Boolean IOHIDElement_GetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long *outValue);
	extern void IOHIDElement_SetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long inValue);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDElement___ //
//	IN NO EVENT SHALL APPLE BE LIABLE FOR ANY SPECIAL, INDIRECT, INCIDENTAL
//*****************************************************
#ifndef __IOHIDElement___
#define __IOHIDElement___

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"
//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidElement( inIOHIDElementRef )
	//
	// Purpose:	validate this element
	//
	// Inputs:	inIOHIDElementRef	- the element
	//
	// Returns:	Boolean			- TRUE if this is a valid element ref
	//
	extern Boolean HIDIsValidElement(IOHIDElementRef inIOHIDElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_GetValue( inElementRef, inIOHIDValueScaleType )
	//
	// Purpose:	returns the current value for an element( polling )
	//
	// Notes:	will return 0 on error conditions which should be accounted for by application
	//
	// Inputs:	inElementRef	- the element
	//			inIOHIDValueScaleType	- scale type ( calibrated or physical )
	//
	// Returns:	double		- current value for element
	//
	extern double IOHIDElement_GetValue(IOHIDElementRef inElementRef, IOHIDValueScaleType inIOHIDValueScaleType);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMin( inElementRef )
	//
	// Purpose:	get the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the minimum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the minimum bounds for a calibrated value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMax( inElementRef )
	//
	// Purpose:	get the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMin( inElementRef )
	//
	// Purpose:	get the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMin( inElementRef, inValue )
	//
	// Purpose:	set the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMax( inElementRef )
	//
	// Purpose:	get the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMin( inElementRef )
	//
	// Purpose:	get the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMax( inElementRef )
	//
	// Purpose:	get the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationGranularity( inElementRef )
	//
	// Purpose:	get the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	double_t - the maximum Calibration value for this element
	//
	
	extern double_t  IOHIDElement_GetCalibrationGranularity(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationGranularity( inElementRef, inValue )
	//
	// Purpose:	set the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the the level of detail for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationGranularity(IOHIDElementRef inElementRef, double_t inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_SetupCalibration( inElementRef )
	//
	// Purpose:	set default values for the element calibration parameters
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetupCalibration(IOHIDElementRef inIOHIDElementRef);
	
	extern Boolean IOHIDElement_GetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long *outValue);
	extern void IOHIDElement_SetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long inValue);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDElement___ //
//	OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
//*****************************************************
#ifndef __IOHIDElement___
#define __IOHIDElement___

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"
//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidElement( inIOHIDElementRef )
	//
	// Purpose:	validate this element
	//
	// Inputs:	inIOHIDElementRef	- the element
	//
	// Returns:	Boolean			- TRUE if this is a valid element ref
	//
	extern Boolean HIDIsValidElement(IOHIDElementRef inIOHIDElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_GetValue( inElementRef, inIOHIDValueScaleType )
	//
	// Purpose:	returns the current value for an element( polling )
	//
	// Notes:	will return 0 on error conditions which should be accounted for by application
	//
	// Inputs:	inElementRef	- the element
	//			inIOHIDValueScaleType	- scale type ( calibrated or physical )
	//
	// Returns:	double		- current value for element
	//
	extern double IOHIDElement_GetValue(IOHIDElementRef inElementRef, IOHIDValueScaleType inIOHIDValueScaleType);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMin( inElementRef )
	//
	// Purpose:	get the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the minimum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the minimum bounds for a calibrated value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMax( inElementRef )
	//
	// Purpose:	get the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMin( inElementRef )
	//
	// Purpose:	get the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMin( inElementRef, inValue )
	//
	// Purpose:	set the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMax( inElementRef )
	//
	// Purpose:	get the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMin( inElementRef )
	//
	// Purpose:	get the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMax( inElementRef )
	//
	// Purpose:	get the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationGranularity( inElementRef )
	//
	// Purpose:	get the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	double_t - the maximum Calibration value for this element
	//
	
	extern double_t  IOHIDElement_GetCalibrationGranularity(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationGranularity( inElementRef, inValue )
	//
	// Purpose:	set the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the the level of detail for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationGranularity(IOHIDElementRef inElementRef, double_t inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_SetupCalibration( inElementRef )
	//
	// Purpose:	set default values for the element calibration parameters
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetupCalibration(IOHIDElementRef inIOHIDElementRef);
	
	extern Boolean IOHIDElement_GetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long *outValue);
	extern void IOHIDElement_SetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long inValue);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDElement___ //
//	SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
//*****************************************************
#ifndef __IOHIDElement___
#define __IOHIDElement___

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"
//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidElement( inIOHIDElementRef )
	//
	// Purpose:	validate this element
	//
	// Inputs:	inIOHIDElementRef	- the element
	//
	// Returns:	Boolean			- TRUE if this is a valid element ref
	//
	extern Boolean HIDIsValidElement(IOHIDElementRef inIOHIDElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_GetValue( inElementRef, inIOHIDValueScaleType )
	//
	// Purpose:	returns the current value for an element( polling )
	//
	// Notes:	will return 0 on error conditions which should be accounted for by application
	//
	// Inputs:	inElementRef	- the element
	//			inIOHIDValueScaleType	- scale type ( calibrated or physical )
	//
	// Returns:	double		- current value for element
	//
	extern double IOHIDElement_GetValue(IOHIDElementRef inElementRef, IOHIDValueScaleType inIOHIDValueScaleType);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMin( inElementRef )
	//
	// Purpose:	get the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the minimum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the minimum bounds for a calibrated value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMax( inElementRef )
	//
	// Purpose:	get the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMin( inElementRef )
	//
	// Purpose:	get the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMin( inElementRef, inValue )
	//
	// Purpose:	set the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMax( inElementRef )
	//
	// Purpose:	get the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMin( inElementRef )
	//
	// Purpose:	get the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMax( inElementRef )
	//
	// Purpose:	get the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationGranularity( inElementRef )
	//
	// Purpose:	get the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	double_t - the maximum Calibration value for this element
	//
	
	extern double_t  IOHIDElement_GetCalibrationGranularity(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationGranularity( inElementRef, inValue )
	//
	// Purpose:	set the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the the level of detail for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationGranularity(IOHIDElementRef inElementRef, double_t inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_SetupCalibration( inElementRef )
	//
	// Purpose:	set default values for the element calibration parameters
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetupCalibration(IOHIDElementRef inIOHIDElementRef);
	
	extern Boolean IOHIDElement_GetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long *outValue);
	extern void IOHIDElement_SetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long inValue);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDElement___ //
//	INTERRUPTION) ARISING IN ANY WAY OUT OF THE USE, REPRODUCTION,
//*****************************************************
#ifndef __IOHIDElement___
#define __IOHIDElement___

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"
//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidElement( inIOHIDElementRef )
	//
	// Purpose:	validate this element
	//
	// Inputs:	inIOHIDElementRef	- the element
	//
	// Returns:	Boolean			- TRUE if this is a valid element ref
	//
	extern Boolean HIDIsValidElement(IOHIDElementRef inIOHIDElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_GetValue( inElementRef, inIOHIDValueScaleType )
	//
	// Purpose:	returns the current value for an element( polling )
	//
	// Notes:	will return 0 on error conditions which should be accounted for by application
	//
	// Inputs:	inElementRef	- the element
	//			inIOHIDValueScaleType	- scale type ( calibrated or physical )
	//
	// Returns:	double		- current value for element
	//
	extern double IOHIDElement_GetValue(IOHIDElementRef inElementRef, IOHIDValueScaleType inIOHIDValueScaleType);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMin( inElementRef )
	//
	// Purpose:	get the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the minimum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the minimum bounds for a calibrated value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMax( inElementRef )
	//
	// Purpose:	get the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMin( inElementRef )
	//
	// Purpose:	get the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMin( inElementRef, inValue )
	//
	// Purpose:	set the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMax( inElementRef )
	//
	// Purpose:	get the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMin( inElementRef )
	//
	// Purpose:	get the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMax( inElementRef )
	//
	// Purpose:	get the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationGranularity( inElementRef )
	//
	// Purpose:	get the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	double_t - the maximum Calibration value for this element
	//
	
	extern double_t  IOHIDElement_GetCalibrationGranularity(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationGranularity( inElementRef, inValue )
	//
	// Purpose:	set the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the the level of detail for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationGranularity(IOHIDElementRef inElementRef, double_t inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_SetupCalibration( inElementRef )
	//
	// Purpose:	set default values for the element calibration parameters
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetupCalibration(IOHIDElementRef inIOHIDElementRef);
	
	extern Boolean IOHIDElement_GetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long *outValue);
	extern void IOHIDElement_SetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long inValue);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDElement___ //
//	MODIFICATION AND/OR DISTRIBUTION OF THE APPLE SOFTWARE, HOWEVER CAUSED
//*****************************************************
#ifndef __IOHIDElement___
#define __IOHIDElement___

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"
//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidElement( inIOHIDElementRef )
	//
	// Purpose:	validate this element
	//
	// Inputs:	inIOHIDElementRef	- the element
	//
	// Returns:	Boolean			- TRUE if this is a valid element ref
	//
	extern Boolean HIDIsValidElement(IOHIDElementRef inIOHIDElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_GetValue( inElementRef, inIOHIDValueScaleType )
	//
	// Purpose:	returns the current value for an element( polling )
	//
	// Notes:	will return 0 on error conditions which should be accounted for by application
	//
	// Inputs:	inElementRef	- the element
	//			inIOHIDValueScaleType	- scale type ( calibrated or physical )
	//
	// Returns:	double		- current value for element
	//
	extern double IOHIDElement_GetValue(IOHIDElementRef inElementRef, IOHIDValueScaleType inIOHIDValueScaleType);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMin( inElementRef )
	//
	// Purpose:	get the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the minimum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the minimum bounds for a calibrated value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMax( inElementRef )
	//
	// Purpose:	get the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMin( inElementRef )
	//
	// Purpose:	get the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMin( inElementRef, inValue )
	//
	// Purpose:	set the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMax( inElementRef )
	//
	// Purpose:	get the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMin( inElementRef )
	//
	// Purpose:	get the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMax( inElementRef )
	//
	// Purpose:	get the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationGranularity( inElementRef )
	//
	// Purpose:	get the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	double_t - the maximum Calibration value for this element
	//
	
	extern double_t  IOHIDElement_GetCalibrationGranularity(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationGranularity( inElementRef, inValue )
	//
	// Purpose:	set the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the the level of detail for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationGranularity(IOHIDElementRef inElementRef, double_t inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_SetupCalibration( inElementRef )
	//
	// Purpose:	set default values for the element calibration parameters
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetupCalibration(IOHIDElementRef inIOHIDElementRef);
	
	extern Boolean IOHIDElement_GetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long *outValue);
	extern void IOHIDElement_SetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long inValue);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDElement___ //
//	AND WHETHER UNDER THEORY OF CONTRACT, TORT (INCLUDING NEGLIGENCE),
//*****************************************************
#ifndef __IOHIDElement___
#define __IOHIDElement___

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"
//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidElement( inIOHIDElementRef )
	//
	// Purpose:	validate this element
	//
	// Inputs:	inIOHIDElementRef	- the element
	//
	// Returns:	Boolean			- TRUE if this is a valid element ref
	//
	extern Boolean HIDIsValidElement(IOHIDElementRef inIOHIDElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_GetValue( inElementRef, inIOHIDValueScaleType )
	//
	// Purpose:	returns the current value for an element( polling )
	//
	// Notes:	will return 0 on error conditions which should be accounted for by application
	//
	// Inputs:	inElementRef	- the element
	//			inIOHIDValueScaleType	- scale type ( calibrated or physical )
	//
	// Returns:	double		- current value for element
	//
	extern double IOHIDElement_GetValue(IOHIDElementRef inElementRef, IOHIDValueScaleType inIOHIDValueScaleType);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMin( inElementRef )
	//
	// Purpose:	get the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the minimum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the minimum bounds for a calibrated value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMax( inElementRef )
	//
	// Purpose:	get the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMin( inElementRef )
	//
	// Purpose:	get the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMin( inElementRef, inValue )
	//
	// Purpose:	set the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMax( inElementRef )
	//
	// Purpose:	get the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMin( inElementRef )
	//
	// Purpose:	get the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMax( inElementRef )
	//
	// Purpose:	get the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationGranularity( inElementRef )
	//
	// Purpose:	get the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	double_t - the maximum Calibration value for this element
	//
	
	extern double_t  IOHIDElement_GetCalibrationGranularity(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationGranularity( inElementRef, inValue )
	//
	// Purpose:	set the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the the level of detail for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationGranularity(IOHIDElementRef inElementRef, double_t inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_SetupCalibration( inElementRef )
	//
	// Purpose:	set default values for the element calibration parameters
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetupCalibration(IOHIDElementRef inIOHIDElementRef);
	
	extern Boolean IOHIDElement_GetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long *outValue);
	extern void IOHIDElement_SetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long inValue);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDElement___ //
//	STRICT LIABILITY OR OTHERWISE, EVEN IF APPLE HAS BEEN ADVISED OF THE
//*****************************************************
#ifndef __IOHIDElement___
#define __IOHIDElement___

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"
//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidElement( inIOHIDElementRef )
	//
	// Purpose:	validate this element
	//
	// Inputs:	inIOHIDElementRef	- the element
	//
	// Returns:	Boolean			- TRUE if this is a valid element ref
	//
	extern Boolean HIDIsValidElement(IOHIDElementRef inIOHIDElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_GetValue( inElementRef, inIOHIDValueScaleType )
	//
	// Purpose:	returns the current value for an element( polling )
	//
	// Notes:	will return 0 on error conditions which should be accounted for by application
	//
	// Inputs:	inElementRef	- the element
	//			inIOHIDValueScaleType	- scale type ( calibrated or physical )
	//
	// Returns:	double		- current value for element
	//
	extern double IOHIDElement_GetValue(IOHIDElementRef inElementRef, IOHIDValueScaleType inIOHIDValueScaleType);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMin( inElementRef )
	//
	// Purpose:	get the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the minimum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the minimum bounds for a calibrated value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMax( inElementRef )
	//
	// Purpose:	get the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMin( inElementRef )
	//
	// Purpose:	get the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMin( inElementRef, inValue )
	//
	// Purpose:	set the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMax( inElementRef )
	//
	// Purpose:	get the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMin( inElementRef )
	//
	// Purpose:	get the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMax( inElementRef )
	//
	// Purpose:	get the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationGranularity( inElementRef )
	//
	// Purpose:	get the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	double_t - the maximum Calibration value for this element
	//
	
	extern double_t  IOHIDElement_GetCalibrationGranularity(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationGranularity( inElementRef, inValue )
	//
	// Purpose:	set the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the the level of detail for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationGranularity(IOHIDElementRef inElementRef, double_t inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_SetupCalibration( inElementRef )
	//
	// Purpose:	set default values for the element calibration parameters
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetupCalibration(IOHIDElementRef inIOHIDElementRef);
	
	extern Boolean IOHIDElement_GetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long *outValue);
	extern void IOHIDElement_SetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long inValue);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDElement___ //
//	POSSIBILITY OF SUCH DAMAGE.
//*****************************************************
#ifndef __IOHIDElement___
#define __IOHIDElement___

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"
//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidElement( inIOHIDElementRef )
	//
	// Purpose:	validate this element
	//
	// Inputs:	inIOHIDElementRef	- the element
	//
	// Returns:	Boolean			- TRUE if this is a valid element ref
	//
	extern Boolean HIDIsValidElement(IOHIDElementRef inIOHIDElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_GetValue( inElementRef, inIOHIDValueScaleType )
	//
	// Purpose:	returns the current value for an element( polling )
	//
	// Notes:	will return 0 on error conditions which should be accounted for by application
	//
	// Inputs:	inElementRef	- the element
	//			inIOHIDValueScaleType	- scale type ( calibrated or physical )
	//
	// Returns:	double		- current value for element
	//
	extern double IOHIDElement_GetValue(IOHIDElementRef inElementRef, IOHIDValueScaleType inIOHIDValueScaleType);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMin( inElementRef )
	//
	// Purpose:	get the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the minimum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the minimum bounds for a calibrated value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMax( inElementRef )
	//
	// Purpose:	get the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMin( inElementRef )
	//
	// Purpose:	get the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMin( inElementRef, inValue )
	//
	// Purpose:	set the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMax( inElementRef )
	//
	// Purpose:	get the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMin( inElementRef )
	//
	// Purpose:	get the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMax( inElementRef )
	//
	// Purpose:	get the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationGranularity( inElementRef )
	//
	// Purpose:	get the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	double_t - the maximum Calibration value for this element
	//
	
	extern double_t  IOHIDElement_GetCalibrationGranularity(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationGranularity( inElementRef, inValue )
	//
	// Purpose:	set the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the the level of detail for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationGranularity(IOHIDElementRef inElementRef, double_t inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_SetupCalibration( inElementRef )
	//
	// Purpose:	set default values for the element calibration parameters
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetupCalibration(IOHIDElementRef inIOHIDElementRef);
	
	extern Boolean IOHIDElement_GetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long *outValue);
	extern void IOHIDElement_SetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long inValue);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDElement___ //
//	
//*****************************************************
#ifndef __IOHIDElement___
#define __IOHIDElement___

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"
//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidElement( inIOHIDElementRef )
	//
	// Purpose:	validate this element
	//
	// Inputs:	inIOHIDElementRef	- the element
	//
	// Returns:	Boolean			- TRUE if this is a valid element ref
	//
	extern Boolean HIDIsValidElement(IOHIDElementRef inIOHIDElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_GetValue( inElementRef, inIOHIDValueScaleType )
	//
	// Purpose:	returns the current value for an element( polling )
	//
	// Notes:	will return 0 on error conditions which should be accounted for by application
	//
	// Inputs:	inElementRef	- the element
	//			inIOHIDValueScaleType	- scale type ( calibrated or physical )
	//
	// Returns:	double		- current value for element
	//
	extern double IOHIDElement_GetValue(IOHIDElementRef inElementRef, IOHIDValueScaleType inIOHIDValueScaleType);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMin( inElementRef )
	//
	// Purpose:	get the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the minimum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the minimum bounds for a calibrated value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMax( inElementRef )
	//
	// Purpose:	get the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMin( inElementRef )
	//
	// Purpose:	get the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMin( inElementRef, inValue )
	//
	// Purpose:	set the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMax( inElementRef )
	//
	// Purpose:	get the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMin( inElementRef )
	//
	// Purpose:	get the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMax( inElementRef )
	//
	// Purpose:	get the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationGranularity( inElementRef )
	//
	// Purpose:	get the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	double_t - the maximum Calibration value for this element
	//
	
	extern double_t  IOHIDElement_GetCalibrationGranularity(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationGranularity( inElementRef, inValue )
	//
	// Purpose:	set the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the the level of detail for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationGranularity(IOHIDElementRef inElementRef, double_t inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_SetupCalibration( inElementRef )
	//
	// Purpose:	set default values for the element calibration parameters
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetupCalibration(IOHIDElementRef inIOHIDElementRef);
	
	extern Boolean IOHIDElement_GetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long *outValue);
	extern void IOHIDElement_SetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long inValue);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDElement___ //
//	Copyright (C) 2009 Apple Inc. All Rights Reserved.
//*****************************************************
#ifndef __IOHIDElement___
#define __IOHIDElement___

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"
//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidElement( inIOHIDElementRef )
	//
	// Purpose:	validate this element
	//
	// Inputs:	inIOHIDElementRef	- the element
	//
	// Returns:	Boolean			- TRUE if this is a valid element ref
	//
	extern Boolean HIDIsValidElement(IOHIDElementRef inIOHIDElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_GetValue( inElementRef, inIOHIDValueScaleType )
	//
	// Purpose:	returns the current value for an element( polling )
	//
	// Notes:	will return 0 on error conditions which should be accounted for by application
	//
	// Inputs:	inElementRef	- the element
	//			inIOHIDValueScaleType	- scale type ( calibrated or physical )
	//
	// Returns:	double		- current value for element
	//
	extern double IOHIDElement_GetValue(IOHIDElementRef inElementRef, IOHIDValueScaleType inIOHIDValueScaleType);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMin( inElementRef )
	//
	// Purpose:	get the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the minimum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the minimum bounds for a calibrated value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMax( inElementRef )
	//
	// Purpose:	get the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMin( inElementRef )
	//
	// Purpose:	get the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMin( inElementRef, inValue )
	//
	// Purpose:	set the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMax( inElementRef )
	//
	// Purpose:	get the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMin( inElementRef )
	//
	// Purpose:	get the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMax( inElementRef )
	//
	// Purpose:	get the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationGranularity( inElementRef )
	//
	// Purpose:	get the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	double_t - the maximum Calibration value for this element
	//
	
	extern double_t  IOHIDElement_GetCalibrationGranularity(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationGranularity( inElementRef, inValue )
	//
	// Purpose:	set the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the the level of detail for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationGranularity(IOHIDElementRef inElementRef, double_t inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_SetupCalibration( inElementRef )
	//
	// Purpose:	set default values for the element calibration parameters
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetupCalibration(IOHIDElementRef inIOHIDElementRef);
	
	extern Boolean IOHIDElement_GetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long *outValue);
	extern void IOHIDElement_SetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long inValue);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDElement___ //
//	
//*****************************************************
#ifndef __IOHIDElement___
#define __IOHIDElement___

//*****************************************************
#pragma mark - includes & imports

#include <AvailabilityMacros.h>

#include "IOHIDLib_.h"
//*****************************************************
#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif
	
#if PRAGMA_IMPORT
#pragma import on
#endif
	
#if PRAGMA_STRUCT_ALIGN
#pragma options align=mac68k
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(push, 2)
#elif PRAGMA_STRUCT_PACK
#pragma pack(2)
#endif
	
	//*****************************************************
#pragma mark - typedef's, struct's, enums, defines, etc.
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported globals
	//-----------------------------------------------------
	
	//*****************************************************
#pragma mark - exported function prototypes
	//-----------------------------------------------------
	
	//*************************************************************************
	//
	// HIDIsValidElement( inIOHIDElementRef )
	//
	// Purpose:	validate this element
	//
	// Inputs:	inIOHIDElementRef	- the element
	//
	// Returns:	Boolean			- TRUE if this is a valid element ref
	//
	extern Boolean HIDIsValidElement(IOHIDElementRef inIOHIDElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_GetValue( inElementRef, inIOHIDValueScaleType )
	//
	// Purpose:	returns the current value for an element( polling )
	//
	// Notes:	will return 0 on error conditions which should be accounted for by application
	//
	// Inputs:	inElementRef	- the element
	//			inIOHIDValueScaleType	- scale type ( calibrated or physical )
	//
	// Returns:	double		- current value for element
	//
	extern double IOHIDElement_GetValue(IOHIDElementRef inElementRef, IOHIDValueScaleType inIOHIDValueScaleType);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMin( inElementRef )
	//
	// Purpose:	get the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the minimum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the minimum bounds for a calibrated value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationMax( inElementRef )
	//
	// Purpose:	get the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds for a calibrated value for this element
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMin( inElementRef )
	//
	// Purpose:	get the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMin( inElementRef, inValue )
	//
	// Purpose:	set the mininum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationSaturationMax( inElementRef )
	//
	// Purpose:	get the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationSaturationMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationSaturationMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum tolerance to be used when calibrating a logical element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationSaturationMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMin( inElementRef )
	//
	// Purpose:	get the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMin(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMin( inElementRef, inValue )
	//
	// Purpose:	set the minimum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMin(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationDeadZoneMax( inElementRef )
	//
	// Purpose:	get the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	CFIndex - the maximum Calibration value for this element
	//
	
	extern CFIndex  IOHIDElement_GetCalibrationDeadZoneMax(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationDeadZoneMax( inElementRef, inValue )
	//
	// Purpose:	set the maximum bounds near the midpoint of a logical value in which the value is ignored
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the maximum Calibration value for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationDeadZoneMax(IOHIDElementRef inElementRef, CFIndex inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_GetCalibrationGranularity( inElementRef )
	//
	// Purpose:	get the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef - the IOHIDElementRef for this element
	//
	// Returns:	double_t - the maximum Calibration value for this element
	//
	
	extern double_t  IOHIDElement_GetCalibrationGranularity(IOHIDElementRef inElementRef);
	
	//*************************************************************************
	//
	// IOHIDElement_SetCalibrationGranularity( inElementRef, inValue )
	//
	// Purpose:	set the level of detail returned for a calibrated element value
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//			inValue			- the the level of detail for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetCalibrationGranularity(IOHIDElementRef inElementRef, double_t inValue);
	
	//*************************************************************************
	//
	// IOHIDElement_SetupCalibration( inElementRef )
	//
	// Purpose:	set default values for the element calibration parameters
	//
	// Inputs:  inElementRef	- the IOHIDElementRef for this element
	//
	// Returns:	nothing
	//
	
	extern void IOHIDElement_SetupCalibration(IOHIDElementRef inIOHIDElementRef);
	
	extern Boolean IOHIDElement_GetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long *outValue);
	extern void IOHIDElement_SetLongProperty(IOHIDElementRef inElementRef, CFStringRef inKey, long inValue);
	
	//*****************************************************
#if PRAGMA_STRUCT_ALIGN
#pragma options align=reset
#elif PRAGMA_STRUCT_PACKPUSH
#pragma pack(pop)
#elif PRAGMA_STRUCT_PACK
#pragma pack()
#endif
	
#ifdef PRAGMA_IMPORT_OFF
#pragma import off
#elif PRAGMA_IMPORT
#pragma import reset
#endif
	
#ifdef __cplusplus
}
#endif

#endif  // __IOHIDElement___ //
